﻿
namespace Hims.Api.Controllers
{
    using Domain.Services;
    using Hims.Domain.Repositories.UnitOfWork;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Hims.Shared.Library.Enums;
    using Hims.Shared.UserModels;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using System.Threading.Tasks;
    using Utilities;


    /// <summary>
    /// The internal medicine controller.
    /// </summary>
    [Route("api/register")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class RegisterController : BaseController
    {
        private readonly IRegisterService registerService;
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc />
        public RegisterController(
            IRegisterService registerService,
             IUnitOfWork unitOfWork)
        {
            this.registerService = registerService;
            this.unitOfWork = unitOfWork;
        }
        /// <summary>
        /// The modify async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        [Authorize]
        [Route("modify")]
        [ProducesResponseType(typeof(int), 200)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> ModifyAsync([FromBody] RegisterModel model)
        {
            model = (RegisterModel)EmptyFilter.Handler(model);
            var response = await this.registerService.AddAsync(model);
            return this.Success(response);

        }

    }
}


